/* ------------------------------------------------------------------------ */
/* DemoXP.EXE                                                               */
/* Demo Clipper with Windows NT/2000/XP                                     */
/* (c) Wolfgang Riedmann - Meran 1993-2004                                  */
/*                                                                          */
/* Version 1.00 from 08.12.2004                                             */
/* ------------------------------------------------------------------------ */

#include "inkey.ch"
#include "setcurs.ch"
#include "getexit.ch"

#define PROGVERSION "1.00"                                    
#define PROGNAME    "DemoXP - demonstrate CPU hogging under Windows NT/2000/XP"
#define PROGDATUM   "08.12.2004"
#define COPYRIGHT   "(c) Wolfgang Riedmann 1994-2004"

// colors
#define C_DESKTOP         "W+/BG,W+/N,,,N/W"
#define C_STD             "N/W,W+/N,,,W+/W"
#define C_STDGET          "B/W,W+/N,,,B/W"
    
// boxes    
#define B_SINGLE        "Ŀ "
#define B_SINGLEV       "Ŀ"
#define B_DOUBLE        "ͻȺ "
#define B_DOUBLEV       "ͻȺ"
#define B_SDOUBLE       "ķӺ "
#define B_SDOUBLEV      "ķӺ"
#define B_DSINGLE       "͸Գ "
#define B_DSINGLEV      "͸Գ"
#define B_WITHOUT       ""
    
STATIC oScreen                              // original screen


/* --------------------------- *
* main() -> nRetcode
*/
function main( parm1 )

    IF ValType( parm1 ) == "C" .AND. ! "/D" $ UPPER( parm1 )
        ALTD(0)
    ENDIF

    oScreen  := Window( 0, 0, MaxRow(), MaxCol() )
    oScreen:color   := C_DESKTOP
    oScreen:box     := Replicate( "", 9 )
    SetPos( 0, 0 )
    oScreen:open()

    ControlXP()

    RETURN NIL

/* --------------------------- *
* ControlXP() -> NIL
* displays some OS informations and let's modify the CPU utilization
*/
function ControlXP()

    LOCAL oWindow   
    local cDosVer
    local nDosVer
    local oMsgBox          
    local nResult
    local cSystem
    local lNT
    
    oWindow			:= Window( 3, 3, 20, MaxCol() - 3, C_STD, PROGNAME, .t. )
    oWindow:Open()
                 
    cDosVer			:= FT_DosVer()
    nDosVer			:= Val( cDosVer )
    @ 5, 5 SAY "DOS version:" color C_STD
    @ 5, 25 SAY cDosVer color C_STD
    @ 6, 5 SAY "Operating system:"
             
    lNT				:= .f.
    DO CASE
    CASE nDosVer >= 7.0         // Windows 9x
    	@ 6, 25 SAY "Windows 95/98" color C_STD
    CASE "WINDOWS_NT" $ Upper( GetEnv( "OS" ) )
        // NT: environment variable OS is set by NT and descendants at boot
    	@ 6, 25 SAY "Windows NT/2000/XP" color C_STD
    	lNt					:= .t.
    CASE ! Empty( GetEnv( "WINDIR" ) )  // andere Windows-Version
    	@ 6, 25 SAY "other Windows" color C_STD
    OTHERWISE
    	@ 6, 25 SAY "MS DOS " + cDosVer color C_STD
    ENDCASE      
            
    __Run( IIf( lNT, "CMD", "COMMAND" ) + " /c VER >system.txt" )
    cSystem				:= StrTran( StrTran( AllTrim( MemoRead( "system.txt" ) ), chr( 13 ), "" ), chr( 10 ), "" )
    @ 7, 5 SAY "Effective OS:" color C_STD
    @ 7, 25 SAY cSystem color C_STD
    
	while .t.
		oMsgBox    		:= MsgBox( "Set the idle state", "Set the idle state of the program", { "[ ON ]", "[ OFF ]", "[ Exit ]" }, C_STDGET )
		nResult			:= oMsgBox:Show()
		if nResult == 0 .or. nResult == 3
			exit
		endif
		SetIdleState( nResult == 1 )
	end
	
	oWindow:Close()
    
    return nil


/* --------------------------- *
* SetIdleState() -> NIL
* sets the idle state
*/
function SetIdleState( lOn )

	local nDosVer
	
	if ValType( lOn ) != "L"
		lOn			:= .t.
	endif
                          
    nDosVer := Val( FT_DosVer( ) )     // Dos version
    DO CASE
    CASE lOn == .f.
        FT_OnIdle( nil )
    CASE nDosVer >= 7.0         // Windows 9x
        FT_OnIdle( {||FT_IAmIdle( 30, .F.)} )
    CASE "WINDOWS_NT" $ Upper( GetEnv( "OS" ) )		// Windows NT/2000/XP
        FT_OnIdle( {||FT_IAmIdle( 30, .T.)} )
    CASE ! Empty( GetEnv( "WINDIR" ) )  // other windows version
        FT_OnIdle( {||FT_IAmIdle( 30, .F.)} )
    OTHERWISE
        // MS DOS
    ENDCASE
	
	return nil

/* --------------------------- *
* ExitProg( nErrorlevel ) -> NIL
* closes all files and resets the settings
*/
EXIT function ExitProg( nErrorlevel )

    //DBCloseAll()

    IF oScreen != NIL
        oScreen:close()
    ENDIF
    ALTD( 0 )       // deacivate the debugger

	RETURN NIL

