// mySLE.prg
CLASS mySLE INHERIT SingleLineEdit       

CONSTRUCTOR(oOwner, xID, oPoint, oDimension, kStyle)  
   SUPER(oOwner, xID, oPoint, oDimension, kStyle)
   RETURN

METHOD CreateFormattedString(cPicture, cType, cDefTempl) 
	SELF:oEditString := rightSLEFormattedString{SELF, cPicture, cType, wOverWrite, cDefTempl, wScrMode}
	RETURN SELF
		
ASSIGN __Value(uNewValue AS USUAL) AS VOID
	//PP-030828 Strong typing
	

	IF (oEditString != NULL_OBJECT .AND. (oFieldSpec == NULL_OBJECT))
		oEditString:UsualValue := uNewValue
		SELF:uValue := uNewValue
		oHLStatus := NULL_OBJECT
		SELF:Modified := FALSE
		SELF:lChanged := TRUE
	ELSE
		SUPER:__Value := uNewValue
	ENDIF
	RETURN
	
END CLASS

CLASS rightSLEFormattedString INHERIT __FormattedString

CONSTRUCTOR(Owner, PicString, Type, OverWrite, DefTempl, ScrMode) 
    SUPER(Owner, PicString, Type, OverWrite, DefTempl, ScrMode) 
    //InfoBox{NIL,"Result",SELF:sTemplate}:show()
	RETURN 

ACCESS Template 
       RETURN SELF:sTemplate
/****************************************************************************/
ACCESS EmptyValue AS STRING 

	//p Access to return an empty value for a given picture
	//l Access to return an empty value for a given picture
	//d this access will return an empty string for a given picture
	//r STRING
	
	LOCAL sEmpty 		AS STRING
	LOCAL cCurTplChar 	AS STRING
	LOCAL cTempChr		AS STRING
	LOCAL cPicture		AS STRING
	LOCAL i 			AS LONGINT
	LOCAL nCurPos		AS LONGINT

	sEmpty := ""
    IF Instr("$",sPicture)
    	cPicture := Right(sPicture,SLen(sPicture) - RAt("$",sPicture)-1)	// get rid of the $ now that we know it is there
		cTempChr := OBJECT(SELF:oEditOwner):CurrencySymbol()
		IF !Empty(cTempChr)
			nCurPos	:= OBJECT(SELF:oEditOwner):CurrencyPosition
			DO CASE
				CASE nCurPos == 0
					cPicture := "@R " + cTempChr + cPicture
				CASE nCurPos == 2				
					cPicture := "@R " + cTempChr + " " + cPicture
				CASE nCurPos == 1
					cPicture := "@R " + cPicture + cTempChr
				CASE nCurPos == 3
					cPicture := "@R " + cPicture + " " + cTempChr
				OTHERWISE
					cPicture := "@R " + cTempChr + cPicture					
			ENDCASE
			SELF:Picture := cPicture
			IF !Empty(SELF:oEditOwner:fieldSpec)
				SELF:oEditOwner:fieldSpec:picture := cPicture
			ENDIF
		ENDIF
	ENDIF

	FOR i:=1 UPTO iTemplLen
		cCurTplChar := CharPos(sTemplate, (dword)i)
		IF IsEditTemplChar(cCurTplChar)
			IF (sEmpty == NULL_STRING)
				sEmpty := Space(1)
			ELSE
				sEmpty += " "
			ENDIF
		ELSE
			IF (cCurTplChar == ".") .and. (cType == "N")
				sEmpty += CHR(wDecSep)
			ELSEIF (cCurTplChar == ",") .and. (cType == "N")
				sEmpty += CHR(wThousSep)
			ELSE
				sEmpty += cCurTplChar
			ENDIF
		ENDIF
	NEXT

	RETURN sEmpty       
END CLASS
/****************************************************************************/
STATIC FUNCTION IsEditTemplChar(cTest AS STRING) AS LOGIC
	//p function to see if a character is in the edit template
	//l function to see if a character is in the edit template
	//d this function takes a character as input and tests to see if it part of the \line
	//d standard VO edit template characters.
	//r LOGIC
	//a cTest \tab - String \tab - Character to test
   RETURN At2(cTest, "ANX9!YL#") != 0
