// Code.prg
USING System.Windows.Forms

DEFINE VK_RETURN := 13
DEFINE WM_GETDLGCODE := 135

BEGIN NAMESPACE TestRightSLEonHybrid
    internal _DLL FUNCTION GetFocus() AS IntPTR PASCAL:USER32.GetFocus
    internal _DLL FUNCTION SendMessage(hwnd AS IntPTR, Msg AS DWORD, wParam AS DWORD, lParam AS LONG);
	AS LONG PASCAL:USER32.SendMessageA

   STATIC CLASS VOTools

       STATIC METHOD ShowVODialogWindow(oParent AS System.Windows.Forms.Form, oDlg AS dlgWindow) AS VOID
          LOCAL oForm AS WinFormVOWindow
          LOCAL oPanel AS Panel

          oPanel := Panel{}
          oPanel:Dock := DockStyle.Fill

          oForm := WinFormVOWindow{}
          oForm:Text := oDlg:Caption // "Form hosting a VO DialogWindow"
          oForm:Controls:Add(oPanel)
          oForm:FormBorderStyle := FormBorderStyle.FixedDialog
          oForm:MaximizeBox  := FALSE
          // oForm:MinimizeBox  := FALSE
          oForm:MdiParent    := oParent
          oForm:ClientSize   := System.Drawing.Size{oDlg:Size:Width, oDlg:Size:Height-22} // subtract the height of the caption bar

          oDlg:NetHost := oForm

          oForm:VOWindowHost := MDWinFormVOWindowHost{} //Vulcan.WinFormVOWindowHost{} //MDWinFormVOWindowHost{}
          oForm:VOWindowHost:HostingControl := oPanel
          oForm:VOWindowHost:VOWindow := oDlg

          //oForm:Closed += EventHandler{SELF , @VODialogClosed()}
          oForm:Show()

          RETURN

END CLASS
// *********************************************************************************
// *********************************************************************************
CLASS dlgWindow INHERIT DialogWindow

   PROTECT oNetHost AS System.Windows.Forms.Form
    Constructor(oOwner,uxResource,lVar)
        super(oOwner,uxResource,lVar)
        return
   Access NetHost as System.Windows.Forms.Form
    RETURN self:oNetHost
   ASSIGN NetHost(oForm AS System.Windows.Forms.Form) AS VOID
      SELF:oNetHost := oForm
      RETURN

END CLASS 
// *********************************************************************************
// *********************************************************************************
CLASS MDWinFormVOWindowHost INHERIT XSharp.WinFormVOWindowHost
      CONSTRUCTOR() STRICT
         SUPER()
         RETURN

   METHOD ProcessDialogKey(keyData AS System.Windows.Forms.Keys ) AS LOGIC
      // MAY per 06.01.2011: Workaround - if the Enter key arrives, send a WM_GetDlgCode message to the control
      LOCAL lKeyProcessed AS LOGIC
      LOCAL oVOWin AS VO.Window

      lKeyProcessed := FALSE
      oVOWin := SELF:VOWindow
      IF ! oVOWin == NULL
         IF keyData == System.Windows.Forms.Keys.Enter
            lKeyProcessed := TRUE
            SendMessage(GetFocus(), WM_GETDLGCODE, VK_RETURN, 0)
         ELSE
            lKeyProcessed := SUPER:ProcessDialogKey(keyData)
         ENDIF
      ENDIF
      RETURN lKeyProcessed

   END CLASS
// *********************************************************************************
// *********************************************************************************
CLASS Gen_Numeric INHERIT FIELDSPEC
	//USER CODE STARTS HERE (do NOT remove this line)

Constructor() 
    LOCAL   cPict                   AS STRING

    SUPER( HyperLabel{#Gen_Numeric, "", "", "" },  "N", 10, 2 )
    cPict       := "999,999.99"
    IF SLen(cPict) > 0
        SELF:Picture := cPict
    ENDIF

    RETURN  
END CLASS
// *********************************************************************************
END NAMESPACE // TestRightSLEonHybrid
   