﻿Imports System.Windows.Forms
Public Class MaskedTextBox
    Inherits System.Windows.Forms.TextBox

    Private mstrMask As String = ""
    Private mParams() As Char = {CChar("#"), CChar("&"), CChar("!")}

#Region " Component Designer generated code "

    Public Sub New(ByVal Container As System.ComponentModel.IContainer)
        MyClass.New()

        'Required for Windows.Forms Class Composition Designer support
        Container.Add(Me)
    End Sub

    Public Sub New()
        MyBase.New()

        'This call is required by the Component Designer.
        InitializeComponent()

        'Add any initialization after the InitializeComponent() call

    End Sub

    'Component overrides dispose to clean up the component list.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

    'Required by the Component Designer
    Private components As System.ComponentModel.IContainer

    'NOTE: The following procedure is required by the Component Designer
    'It can be modified using the Component Designer.
    'Do not modify it using the code editor.
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        components = New System.ComponentModel.Container()
    End Sub

#End Region

    Public ReadOnly Property UnformatedText() As String
        Get
            Dim i As Integer
            Dim strText As String = ""

            For i = 0 To mstrMask.Length - 1
                If Array.IndexOf(mParams, mstrMask.Chars(i)) > -1 AndAlso Me.Text.Chars(i) <> "_" Then

                    strText += Me.Text.Chars(i)

                End If
            Next

            Return strText

        End Get
    End Property

    Public Property Mask() As String

        Get
            Return (mstrMask)

        End Get

        Set(ByVal Value As String)

            'Use # for Digit only
            'Use & for Letter only
            'Use ! for Letter or Digit
            mstrMask = Value
            Me.Text = mstrMask
            Me.Text = Me.Text.Replace("#", "_").Replace("&", "_").Replace("!", "_")

        End Set

    End Property

    Protected Overrides Sub OnKeyDown(ByVal e As System.Windows.Forms.KeyEventArgs)

        'Disables Delete Key
        If e.KeyCode = Keys.Delete Then
            e.Handled = True
        End If

    End Sub

    Protected Overrides Sub OnKeyPress(ByVal e As System.Windows.Forms.KeyPressEventArgs)

        'key pressed
        Dim chrKeyPressed As Char = e.KeyChar
        'Original cursor position
        Dim intSelStart As Integer = Me.SelectionStart
        'In case of a selection, delete text to this position
        Dim intDelTo As Integer = Me.SelectionStart + Me.SelectionLength - 1

        Dim strText As String = Me.Text
        'Used to avoid deletion of the selection when an invalid key is pressed
        Dim bolDelete As Boolean = False

        Dim i As Integer

        e.Handled = True

        If chrKeyPressed = ControlChars.Back Then
            bolDelete = True
            If intSelStart > 0 And intDelTo < intSelStart Then
                intSelStart -= 1
            End If
        End If

        'Find the Next Insertion point
        For i = Me.SelectionStart To mstrMask.Length - 1

            'Test for # or &
            If mstrMask.Chars(i) = "#" AndAlso Char.IsDigit(chrKeyPressed) _
                OrElse mstrMask.Chars(i) = "&" AndAlso Char.IsLetter(chrKeyPressed) _
                OrElse mstrMask.Chars(i) = "!" AndAlso Char.IsLetterOrDigit(chrKeyPressed) Then

                strText = strText.Remove(i, 1).Insert(i, chrKeyPressed)
                intSelStart = i + 1
                bolDelete = True

            End If

            'Prevent looping unitl the next available match when mixing # & ! on the same mask
            If Array.IndexOf(mParams, mstrMask.Chars(i)) > -1 Then
                Exit For
            End If

        Next

        'Delete remaining chars from selection or previous char if backspace
        If bolDelete Then

            For i = intSelStart To intDelTo

                If Array.IndexOf(mParams, mstrMask.Chars(i)) > -1 Then
                    strText = strText.Remove(i, 1).Insert(i, "_")
                End If

            Next

            Me.Text = strText
            Me.SelectionStart = intSelStart
            Me.SelectionLength = 0
        End If

    End Sub

End Class
