// Application : XSharp.Tools.MySQL
// MyConnection.prg , Created : 24.09.2022   16:11
// User : Wolfgang

using System.Data
using System.Collections
using System.Diagnostics
using System.Collections.Generic
using MySQL.Data.MySqlClient
// using MySQL.Data
using XSharp.Tools.SqlBase

begin namespace XSharp.Tools.MySQL

class MyConnection inherit System.Object implements ISQLConnection, IDisposable
	protect _oConnection 	as MySqlConnection //  MySQL.Data.MySqlClient.MySqlConnection
	protect _lConnected 	as logic
	protect _cLastError		as string
	protect _cSchema		as string
	protect _cConnString	as string

constructor( cServer as string, cDatabaseName as string, cUser as string, cPassword as string )

	super()
	self:OpenConnection( cServer, cDatabaseName, cUser, cPassword )
	self:Initialize()

	return

constructor()

    super()
	self:Initialize()

    return

method Initialize() as logic

	_cSchema			:= "public"

	return true


public property Connection as MySqlConnection get _oConnection
public property Connected as logic get _lConnected
public property LastError as string get _cLastError
public property Schema as string get _cSchema set _cSchema := value
public property ConnString as string get _cConnString

method Dispose() as void

	self:Close()

	return

public method BuildConnectionString( cServer as string, cDatabaseName as string, cUser as string, cPassword as string, cRole as string ) as string

	_cConnString			:= MyHelper.BuildConnectionString( cServer, cDatabaseName, cUser, cPassword, cRole )

	return _cConnString

method Connect( cConnString as string ) as logic

    try

	_cConnString					:= cConnString
    _oConnection        			:= MySqlConnection{}
    _oConnection:ConnectionString 	:= cConnString
    _oConnection:Open()
    _lConnected         			:= self:IsConnectionOpen()
    if _lConnected
	    self:ExecuteStatement( "SET NAMES utf8;" )
    endif

    catch oEx as Exception

    _lConnected         := false
    _cLastError			:= oEx:Message
    Debug.WriteLine( oEx:Message )
	ErrorSys.InvokeExceptionHandler( oEx, ConnString )

    end try

    return _lConnected

method IsConnectionOpen() as logic pascal
    local lReturn       as logic

    lReturn := false
    if _oConnection != null_object
        if _oConnection:State == ConnectionState.Open
            lReturn := true
        endif
    endif

    return lReturn

method ExecuteStatement( cStatement as string ) as int
    local oCommand      as MySqlCommand
    local nReturn       as int

    oCommand        := MysqlCommand{ cStatement, _oConnection }
    nReturn         := oCommand:ExecuteNonQuery()

    return nReturn

method Close() as void

   if _oConnection != null_object
       if _oConnection:State != ConnectionState.Closed
           _oConnection:Close()
       endif
       _oConnection         := null_object
       _lConnected          := false
   endif

return

method GetDataTable( cSelect as string ) as DataTable
	local oAdapter			as MySQLDataAdapter
	local oDataSet			as DataSet
	local oDataTable		as DataTable

    oDataTable          := null_object

	try

	oAdapter            := MySQLDataAdapter{ cSelect, self:Connection }
    oDataSet            := Dataset{}
    oAdapter:Fill( oDataSet )
    oDataTable          := oDataSet:Tables[0]
    oDataSet			:= null_object

	catch oEx as Exception

    _cLastError			:= oEx:Message
    Debug.WriteLine( oEx:Message )
	ErrorSys.InvokeExceptionHandler( oEx, cSelect )

	end try

	return oDataTable

method OpenConnection( cServer as string, cDatabaseName as string, cUser as string, cPassword as string ) as logic
	local lReturn		as logic

	_cConnString 	:= self:BuildConnectionString( cServer, cDatabaseName, cUser, cPassword, "" )
	lReturn			:= self:Connect( _cConnString )

	return lReturn

method OpenConnection( cServer as string, cDatabaseName as string, cUser as string, cPassword as string, cRole as string ) as logic
	local lReturn		as logic

	_cConnString 	:= self:BuildConnectionString( cServer, cDatabaseName, cUser, cPassword, cRole )
	lReturn			:= self:Connect( _cConnString )

	return lReturn

method ExistsTable( cTableName as string ) as logic
	local oTable		as DataTable
	local cSelect		as string
	local oRow			as DataRow
	local lReturn		as logic
	local nCount		as int

	lReturn				:= false
	cSelect				:= String.Format( "select count( * ) as tablecount from information_schema.tables where table_schema = '{1}' and table_name = '{0}'", cTableName, _cSchema )
	Debug.WriteLine( cSelect )
	oTable				:= self:GetDataTable( cSelect )
	if oTable != null .and. oTable:Rows:Count > 0
		oRow				:= oTable:Rows[0]
		nCount				:= oRow:GetInt( "tablecount" )
		if nCount > 0
			lReturn				:= true
		endif
	endif
	if oTable != null
		oTable:Clear()
	endif

	return lReturn

method GetUserTables() as List<string>
	local oList			as List<string>
	local oTables		as DataTable
	local cSelect		as string

	cSelect				:= String.Format( "select distinct table_name as tablename from information_schema.tables where table_schema = '{0}' order by table_name", _cSchema )
	oTables				:= self:GetDataTable( cSelect )
	oList				:= List<string>{}
	if oTables != null
		foreach oRow as DataRow in oTables:Rows
			oList:Add( ( string ) oRow:Item["tablename"] )
		next
	endif
	oTables:Clear()

	return oList

end class

end namespace

