// Application : XSharp.Tools.PostgreSQL
// PGConnection.prg , Created : 24.09.2022   16:58
// User : Wolfgang


using System.Data
using System.Collections
using System.Diagnostics
using System.Collections.Generic
using Npgsql
using XSharp.Tools.SqlBase

begin namespace XSharp.Tools.PostgreSQL

class PGConnection inherit System.Object implements ISQLConnection, IDisposable
	protect _oConnection 	as Npgsql.NpgsqlConnection
	protect _oException		as Exception
	protect _lConnected 	as logic
	protect _cLastError		as string
	protect _cSchema		as string

constructor( cServer as string, cDatabaseName as string, cUser as string, cPassword as string )

	super()
	self:OpenConnection( cServer, cDatabaseName, cUser, cPassword )
	self:Initialize()

	return

constructor()

    super()
	self:Initialize()

    return

method Initialize() as logic

	_cSchema			:= "public"

	return true

public property Connection as Npgsql.NpgsqlConnection get _oConnection
public property Connected as logic get _lConnected
public property LastError as string get _cLastError
public property Schema as string get _cSchema set _cSchema := value
public property Exception as Exception get _oException

method Dispose() as void

	self:Close()

	return

public method BuildConnectionString( cServer as string, cDatabaseName as string, cUser as string, cPassword as string, cRole as string ) as string
	local cConnString			as string

	cConnString			:= PGHelper.BuildConnectionString( cServer, cDatabaseName, cUser, cPassword, cRole )

	return cConnString

method Connect( cConnString as string ) as logic

	self:_ResetException()

    try

    _oConnection        := Npgsql.NpgsqlConnection{}
    _oConnection:ConnectionString := cConnString
    _oConnection:Open()
    _lConnected         := self:IsConnectionOpen()

    catch oEx as Exception

    _lConnected         := false
    _cLastError			:= oEx:Message
    _oException			:= oEx
	oEx:Data:Add( "ConnectionString", cConnString )
    Debug.WriteLine( oEx:Message )
	ErrorSys.InvokeExceptionHandler( oEx, cConnString )

    end try

    return _lConnected

method IsConnectionOpen() as logic pascal
    local lReturn       as logic

    lReturn := false
    if _oConnection != null_object
        if _oConnection:State == ConnectionState.Open
            lReturn := true
        endif
    endif

    return lReturn

method ExecuteStatement( cStatement as string ) as int
    local oCommand      as NpgsqlCommand
    local nReturn       as int

    nReturn			:= -1
	self:_ResetException()

    try

    oCommand        := NpgsqlCommand{ cStatement, _oConnection }
    nReturn         := oCommand:ExecuteNonQuery()

    catch oEx as Exception

	oEx:Data:Add( "Statement", cStatement )
	_oException		:= oEx
    _cLastError		:= oEx:Message + e"\r\n" + cStatement
    Debug.WriteLine( oEx:Message )
	ErrorSys.InvokeExceptionHandler( oEx, cStatement )

    end try

    return nReturn

method Close() as void

   if _oConnection != null_object
       if _oConnection:State != ConnectionState.Closed
           _oConnection:Close()
       endif
       _oConnection         := null_object
       _lConnected          := false
   endif

return

method GetDataTable( cSelect as string ) as DataTable
	local oAdapter			as NpgsqlDataAdapter
	local oDataSet			as DataSet
	local oDataTable		as DataTable

    oDataTable          := null_object
	self:_ResetException()

	try

	oAdapter            := NpgsqlDataAdapter{ cSelect, self:Connection }
    oDataSet            := Dataset{}
    oAdapter:Fill( oDataSet )
    oDataTable          := oDataSet:Tables[0]
    oDataSet			:= null_object

	catch oEx as Exception

    _cLastError			:= oEx:Message
	oEx:Data:Add( "Select", cSelect )
	_oException			:= oEx
    Debug.WriteLine( oEx:Message )
	ErrorSys.InvokeExceptionHandler( oEx, cSelect )

	end try

	return oDataTable

method OpenConnection( cServer as string, cDatabaseName as string, cUser as string, cPassword as string ) as logic
	local ConnString 	as string
	local lReturn		as logic

	ConnString 	:= self:BuildConnectionString( cServer, cDatabaseName, cUser, cPassword, "" )
	lReturn		:= self:Connect( ConnString )

	return lReturn

method OpenConnection( cServer as string, cDatabaseName as string, cUser as string, cPassword as string, cRole as string ) as logic
	local cConnString 	as string
	local lReturn		as logic

	cConnString 	:= self:BuildConnectionString( cServer, cDatabaseName, cUser, cPassword, cRole )
	lReturn			:= self:Connect( cConnString )

	return lReturn

method ExistsTable( cTableName as string ) as logic
	local oTable		as DataTable
	local cSelect		as string
	local oRow			as DataRow
	local lReturn		as logic
	local nCount		as int

	lReturn				:= false
	cSelect				:= String.Format( "select count( * ) as tablecount from information_schema.tables where table_schema = '{1}' and table_name = '{0}'", cTableName, _cSchema )
	Debug.WriteLine( cSelect )
	oTable				:= self:GetDataTable( cSelect )
	if oTable != null .and. oTable:Rows:Count > 0
		oRow				:= oTable:Rows[0]
		nCount				:= oRow:GetInt( "tablecount" )
		if nCount > 0
			lReturn				:= true
		endif
	endif
	if oTable != null
		oTable:Clear()
	endif

	return lReturn

method GetUserTables() as List<string>
	local oList			as List<string>
	local oTables		as DataTable
	local cSelect		as string

	cSelect				:= String.Format( "select distinct table_name as tablename from information_schema.tables where table_schema = '{0}' order by table_name", _cSchema )
	oTables				:= self:GetDataTable( cSelect )
	oList				:= List<string>{}
	if oTables != null
		foreach oRow as DataRow in oTables:Rows
			oList:Add( ( string ) oRow:Item["tablename"] )
		next
	endif
	oTables:Clear()

	return oList

protected method _ResetException() as void

	_oException				:= null
	_cLastError				:= ""

	return

end class

end namespace

