// Application : XSharp.Tools.PostgreSQL
// PGHelper.prg , Created : 24.09.2022   16:59
// User : Wolfgang

using System.Collections
using System.Collections.Generic
using System.Text
using System.Globalization
using Npgsql
using XSharp.Tools.SqlBase

begin namespace XSharp.Tools.PostgreSQL

static class PGHelper
	static _lLogicAsNumeric 	as logic
	static _lLogicAsBit		 	as logic

static constructor()

	_lLogicAsNumeric		:= true
	_lLogicAsBit			:= true

	return

static method CreateInsertString( cTable as string, oFieldValues as ValuesList ) as string
    local oField                as NamedValue
    local oStatement            as StringBuilder
    local oValues               as StringBuilder
    local cStatement            as string
    local nLen					as int
    local nI					as int
    local cValue				as string

    if String.IsNullOrEmpty( cTable )
    	throw ArgumentException{ "no table name was given" }
    endif
    if oFieldValues:Count == 0
    	throw ArgumentException{ String.Format( "no field values for table {0}", cTable ) }
    endif

    cStatement			:= string.Format( "insert into {0} ( ", cTable )
    oStatement          := StringBuilder{ cStatement, 512 }
    oValues             := StringBuilder{ 512 }
    nLen				:= oFieldValues:Count - 1
    for nI := 0 upto nLen
        oField              := oFieldValues[nI]
        cValue				:= PGHelper.ConvertValueToStatement( oField:Value )
        if nI < nLen
            oStatement:AppendFormat( "{0}, ", oField:Name )
            oValues:AppendFormat( "{0}, ", cValue )
        else
            oStatement:AppendFormat( "{0} ) ", oField:Name )
            oValues:AppendFormat( "{0} ) ", cValue )
        endif
    next
    oStatement:Append( " values ( " )
    oStatement:Append( oValues )
    cStatement		:= oStatement:ToString()

    return cStatement

static method CreateUpdateString( cTable as string, oFieldValues as ValuesList, cWhere as string ) as string
    local oField                as NamedValue
    local oStatement            as StringBuilder
    local cStatement			as string
    local nLen					as int
    local nI					as int
    local cValue				as string

    if String.IsNullOrEmpty( cTable )
    	throw ArgumentException{ "no table name was given" }
    endif
    if oFieldValues:Count == 0
    	throw ArgumentException{ String.Format( "no field values for table {0}", cTable ) }
    endif
    if String.IsNullOrEmpty( cWhere )
    	throw ArgumentException{ String.Format( "no where condition was given for update on table {0}", cTable ) }
    endif

    cStatement			:= string.Format( "update {0} set ", cTable )
    oStatement          := StringBuilder{ cStatement, 512 }
    nLen				:= oFieldValues:Count - 1
    cValue				:= ""
    for nI := 0 upto nLen
        oField              := oFieldValues[nI]
        cValue				:= PGHelper.ConvertValueToStatement( oField:Value )
        if nI < nLen
            // oStatement:AppendFormat( e"{0}.\"{1}\" = {2}, ", cTable, oField:Name, cValue )
            oStatement:AppendFormat( e"{0} = {1}, ", oField:Name, cValue )
        else
            // oStatement:AppendFormat( e"{0}.\"{1}\" = {2}", cTable, oField:Name, cValue )
            oStatement:AppendFormat( e"{0} = {1}", oField:Name, cValue )
        endif
    next
    oStatement:AppendFormat( " {0}", cWhere )
    cStatement		:= oStatement:ToString()

    return cStatement

static method BuildConnectionString( cServer as string, cDatabaseName as string, cUser as string, cPassword as string, cRole as string ) as string
    local cConnString 		as string
    local oBuilder 			as NpgsqlConnectionStringBuilder

    oBuilder            := NpgsqlConnectionStringBuilder{}
	oBuilder:Host		:= cServer
	oBuilder:Database	:= cDatabaseName
	oBuilder:Username	:= cUser
	oBuilder:Password	:= cPassword
   	#ifndef net35
   	oBuilder:MaxAutoPrepare	:= 0
   	#endif
   	oBuilder:CommandTimeout	:= 300
	// role gibt es nicht
    cConnString         := oBuilder:ToString()

    return cConnString

static method ConvertValueToStatement( oValue as object ) as string
    local cString           as string

    cString                 := PGHelper.ConvertValueToStatement( oValue, 4 )

    return cString

static method ConvertValueToStatement( oValue as object, nDecimals as int ) as string
    local cValue            as string
    local oDate             as DateTime
    local oString           as StringBuilder

	cValue					:= ""
    do case
    case oValue == null_object .or. oValue = DBNull.Value
        cValue                  := "null"
	case Utility.IsString( oValue ) .and. ( ( string ) oValue ):StartsWith( "expression:" )
		cValue				:= " " + ( ( string ) oValue ):Substring( 11 ) + " "
    case Utility.IsString( oValue )
        cValue                  := string.Format( "'{0}'", PGHelper.FixSQL( oValue ) )
    case Utility.IsFloat( oValue )
        oString                 := StringBuilder{ "{0:F" }
        oString:AppendFormat( "{0:D}", nDecimals )
        oString:Append( "}" )
        cValue                   := string.Format( CultureInfo.InvariantCulture, oString:ToString(), oValue )
    case Utility.IsInteger( oValue )
        cValue                  := string.Format( "{0:D}", oValue )
//    case MiscFuncs.IsVODate( oValue )
//        oDate                   := ( date ) oValue
//        cValue                  := string.Format( "'{0}'", oDate:ToString( "yyyy-MM-dd" ) )
    case Utility.IsDateTime( oValue )
        oDate                   := ( DateTime ) oValue
        // cValue                  := string.Format( "'{0}'", oDate:ToString( "yyyy-MM-dd" ) )
        // Achtung: to_date() konvertiert auch ungltige Datumswerte, z.B. 20190230 nach 02.03.2019
        cValue					:= "to_date('" + oDate:ToString( "yyyyMMdd" ) + "','YYYYMMDD')"
    case Utility:IsLogic( oValue )
    	do case
    	case _lLogicAsBit
	    	if ( logic ) oValue
	    		cValue					:= "'1'"
	    	else
	    		cValue					:= "'0'"
	    	endif
    	case _lLogicAsNumeric
	    	if ( logic ) oValue
	    		cValue					:= "1"
	    	else
	    		cValue					:= "0"
	    	endif
    	otherwise
	    	if ( logic ) oValue
	    		cValue					:= "true"
	    	else
	    		cValue					:= "false"
	    	endif
    	endcase
    otherwise
        cValue                  := oValue:ToString()
    endcase

    return cValue

static method DateToString( oDateTime as DateTime ) as string
	local cReturn			as string

	// cReturn				:= oDateTime:ToString( "yyyy-MM-dd" )
    // Achtung: to_date() konvertiert auch ungltige Datumswerte, z.B. 20190230 nach 02.03.2019
	cReturn				:= "to_date('" + oDateTime:ToString( "yyyyMMdd" ) + "','YYYYMMDD')"

	return cReturn

static method EscapeStringParameter( cParameter as string ) as string
	local cReturn			as string

	if cParameter:Contains( "'" )
		cReturn				:= cParameter:Replace( "'", "''" )
	else
		cReturn				:= cParameter
	endif

	return cReturn

static method FixSQL( oValue as object ) as string pascal
    local cValue            as string
    local oString           as StringBuilder

    oString                 := StringBuilder{ oValue:ToString() }
    oString:Replace( "'", "''" )
    oString:Replace( e"\r\n", "\n" )
    cValue                  := oString:ToString()

    return cValue

static property LogicAsNumeric as logic get _lLogicAsNumeric set _lLogicAsNumeric := value
static property LogicAsBit as logic get _lLogicAsBit set _lLogicAsBit := value


end class

end namespace

