// Application : XSharp.Tools.SqlBase
// DataRowExtensions.prg , Created : 20.08.2022   18:57
// User : Wolfgang

// Application : rdm.SQL
// DataRowExtensions.prg , Created : 17.06.2016   20:25
// User : Wolfgang

using System.Data
using System.Diagnostics
using System.Globalization

begin namespace XSharp.Tools.SqlBase

public static class DataRowExtensions
	static _oCurrentCulture			as IFormatProvider

static constructor()

	_oCurrentCulture			:= CultureInfo.InvariantCulture

	return

#region Public extension methods

public static method CopyValue( self oOrigin as DataRow, oDestination as DataRow ) as void
	local aItemArray			as object[]

	aItemArray				:= oOrigin:ItemArray
	oDestination:ItemArray	:= aItemArray

	return

public static method GetDateTime( self oDataRow as DataRow, cFieldName as string ) as DateTime
	local oValue		as object
	local dReturn		as DateTime

	dReturn			:= DateTime.MinValue

	oValue		:= oDataRow[cFieldName]
	if oValue == DBNull.Value
		dReturn			:= DateTime.MinValue
	else
		dReturn			:= System.Convert.ToDateTime( oValue )
	endif

	return dReturn

public static method GetDateTime( self oDataRow as DataRow, cFieldName as string, dDefault as DateTime ) as DateTime
	local dReturn		as DateTime

	if oDataRow:HasRow( cFieldName )
		dReturn				:= oDataRow:GetDateTime( cFieldName )
	else
		dReturn				:= dDefault
	endif

	return dReturn

public static method GetNullableDateTime( self oDataRow as DataRow, cFieldName as string ) as Nullable<DateTime>
	local oValue		as object
	local dReturn		as Nullable<DateTime>

	dReturn			:= null

	oValue		:= oDataRow[cFieldName]
	if oValue == DBNull.Value
		dReturn			:= null
	else
		dReturn			:= System.Convert.ToDateTime( oValue )
	endif

	return dReturn

public static method GetNullableDateTime( self oDataRow as DataRow, cFieldName as string, dDefault as Nullable<DateTime> ) as Nullable<DateTime>
	local dReturn		as Nullable<DateTime>

	if oDataRow:HasRow( cFieldName )
		dReturn				:= oDataRow:GetNullableDateTime( cFieldName )
	else
		dReturn				:= dDefault
	endif

	return dReturn

public static method GetDecimal( self oDataRow as DataRow, cFieldName as string ) as decimal
	local oValue		as object
	local nReturn		as decimal

	nReturn			:= 0

	oValue			:= oDataRow[cFieldName]
	if oValue == DBNull.Value
		nReturn			:= 0
	else
		nReturn			:= System.Convert.ToDecimal( oValue, _oCurrentCulture )
	endif

	return nReturn

public static method GetDecimal( self oDataRow as DataRow, cFieldName as string, nDefault as decimal ) as decimal
	local nReturn		as decimal

	if oDataRow:HasRow( cFieldName )
		nReturn				:= oDataRow:GetDecimal( cFieldName )
	else
		nReturn				:= nDefault
	endif

	return nReturn

public static method GetDecimal( self oDataRow as DataRow, cFieldName as string, cDecimalSep as string ) as decimal
	local oValue		as object
	local nReturn		as decimal
	local oFormatInfo	as NumberFormatInfo

	nReturn			:= 0

	oValue			:= oDataRow[cFieldName]
	if oValue == DBNull.Value
		nReturn			:= 0
	else
		oFormatInfo		:= NumberFormatInfo{}
		oFormatInfo:NumberDecimalSeparator	:= cDecimalSep
		nReturn			:= System.Convert.ToDecimal( oValue, oFormatInfo )
	endif

	return nReturn

public static method GetDecimal( self oDataRow as DataRow, cFieldName as string, cDecimalSep as string, nDefault as decimal ) as decimal
	local nReturn		as decimal

	if oDataRow:HasRow( cFieldName )
		nReturn				:= oDataRow:GetDecimal( cFieldName, cDecimalSep )
	else
		nReturn				:= nDefault
	endif

	return nReturn

public static method GetInt( self oDataRow as DataRow, cFieldName as string ) as int
	local oValue		as object
	local nReturn		as int

	nReturn			:= 0

	oValue			:= oDataRow[cFieldName]
	if oValue == DBNull.Value
		nReturn			:= 0
	else
		nReturn			:= System.Convert.ToInt32( oValue, _oCurrentCulture )
	endif

	return nReturn

public static method GetInt( self oDataRow as DataRow, cFieldName as string, nDefault as int ) as int
	local nReturn		as int

	if oDataRow:HasRow( cFieldName )
		nReturn				:= oDataRow:GetInt( cFieldName )
	else
		nReturn				:= nDefault
	endif

	return nReturn

public static method GetLogic( self oDataRow as DataRow, cFieldName as string ) as logic
	local oValue		as object
	local lReturn		as logic
	local cValue		as string
	local nValue		as int

	lReturn			:= false

	oValue			:= oDataRow[cFieldName]
	if oValue == DBNull.Value
		lReturn			:= false
	else
		lReturn			:= false
		cValue			:= oValue:ToString()
		if System.Boolean.TryParse( cValue, ref lReturn ) == false		// TryParse does not recognize 1 as valid boolean variable, FallBack to numerics
			// Debug.WriteLine( String.Format( "System.Boolean.TryParse failed on {0}", cValue ) )
			nValue			:= 0
			if System.Int32.TryParse( cValue, ref nValue ) == false
				Debug.WriteLine( String.Format( "System.Int32.TryParse failed on {0}", cValue ) )
			endif
			if nValue != 0
				lReturn				:= true
			endif
		endif
	endif

	return lReturn

public static method GetLogic( self oDataRow as DataRow, cFieldName as string, lDefault as logic ) as logic
	local lReturn		as logic

	if oDataRow:HasRow( cFieldName )
		lReturn				:= oDataRow:GetLogic( cFieldName )
	else
		lReturn				:= lDefault
	endif

	return lReturn

public static method GetString( self oDataRow as DataRow, cFieldName as string ) as string
	local oValue		as object
	local cReturn		as string

	cReturn			:= ""

	oValue			:= oDataRow[cFieldName]
	if oValue == DBNull.Value
		cReturn			:= ""
	else
		cReturn			:= oValue:ToString()
	endif

	return cReturn

public static method GetString( self oDataRow as DataRow, cFieldName as string, cDefault as string ) as string
	local cReturn		as string

	if oDataRow:HasRow( cFieldName )
		cReturn				:= oDataRow:GetString( cFieldName )
	else
		cReturn				:= cDefault
	endif

	return cReturn

public static method GetValue( self oDataRow as DataRow, cFieldName as string ) as object
	local oValue		as object

	oValue			:= oDataRow[cFieldName]

	return oValue

public static method HasRow( self oDataRow as DataRow, cFieldName as string ) as logic
	local lReturn			as logic

	if String.IsNullOrEmpty( cFieldName )
		lReturn				:= false
	else
		lReturn				:= oDataRow:Table:Columns:Contains( cFieldName )
	endif

	return lReturn

public static method SetCulture( oCultureInfo as IFormatProvider ) as void

	_oCurrentCulture			:= oCultureInfo

	return

public static method TableName( self oDataRow as DataRow ) as string
	local cReturn			as string

	if oDataRow:Table != null
		cReturn				:= oDataRow:Table:TableName
	else
		cReturn				:= "unknown"
	endif

	return cReturn

#endregion

end class

end namespace
