// Application : XSharp.Tools.SqlServer
// SQLServerHelper.prg , Created : 24.09.2022   18:31
// User : Wolfgang

using System.Collections
using System.Collections.Generic
using System.Text
using System.Globalization
using System.Data
using System.Data.SqlClient
using XSharp.Tools.SqlBase

begin namespace XSharp.Tools.SqlServer

class SqlServerHelper

constructor()
	return

static method CreateInsertString( cTable as string, oFieldValues as ValuesList ) as string
    local oField                as NamedValue
    local oStatement            as StringBuilder
    local oValues               as StringBuilder
    local cStatement            as string
    local nLen					as int
    local nI					as int
    local cValue				as string

    if String.IsNullOrEmpty( cTable )
    	throw ArgumentException{ "no table name was given" }
    endif
    if oFieldValues:Count == 0
    	throw ArgumentException{ String.Format( "no field values for table {0}", cTable ) }
    endif

    cStatement			:= string.Format( "insert into {0} ( ", cTable )
    oStatement          := StringBuilder{ cStatement, 512 }
    oValues             := StringBuilder{ 512 }
    nLen				:= oFieldValues:Count - 1
    for nI := 0 upto nLen
        oField              := oFieldValues[nI]
        cValue				:= SqlServerHelper.ConvertValueToStatement( oField:Value )
        if nI < nLen
            oStatement:AppendFormat( "{0}, ", oField:Name )
            oValues:AppendFormat( "{0}, ", cValue )
        else
            oStatement:AppendFormat( "{0} ) ", oField:Name )
            oValues:AppendFormat( "{0} ) ", cValue )
        endif
    next
    oStatement:Append( " values ( " )
    oStatement:Append( oValues )
    cStatement		:= oStatement:ToString()

    return cStatement

static method CreateUpdateString( cTable as string, oFieldValues as ValuesList, cWhere as string ) as string
    local oField                as NamedValue
    local oStatement            as StringBuilder
    local cStatement			as string
    local nLen					as int
    local nI					as int
    local cValue				as string

    if String.IsNullOrEmpty( cTable )
    	throw ArgumentException{ "no table name was given" }
    endif
    if oFieldValues:Count == 0
    	throw ArgumentException{ String.Format( "no field values for table {0}", cTable ) }
    endif
    if String.IsNullOrEmpty( cWhere )
    	throw ArgumentException{ String.Format( "no where condition was given for update on table {0}", cTable ) }
    endif

    cStatement			:= string.Format( "update {0} set ", cTable )
    oStatement          := StringBuilder{ cStatement, 512 }
    nLen				:= oFieldValues:Count - 1
    cValue				:= ""
    for nI := 0 upto nLen
        oField              := oFieldValues[nI]
        cValue				:= SqlServerHelper.ConvertValueToStatement( oField:Value )
        if nI < nLen
            oStatement:AppendFormat( e"{0}.\"{1}\" = {2}, ", cTable, oField:Name, cValue )
        else
            oStatement:AppendFormat( e"{0}.\"{1}\" = {2}", cTable, oField:Name, cValue )
        endif
    next
    oStatement:AppendFormat( " {0}", cWhere )
    cStatement		:= oStatement:ToString()

    return cStatement

static method ConvertValueToStatement( oValue as object ) as string
    local cString           as string

    cString                 := SqlServerHelper.ConvertValueToStatement( oValue, 4 )

    return cString

static method ConvertValueToStatement( oValue as object, nDecimals as int ) as string
    local cValue            as string
    local oDate             as DateTime
    local oString           as StringBuilder
    local oExpression		as SqlStringExpression

	cValue					:= ""
    do case
    case oValue == null_object .or. oValue = DBNull.Value
        cValue                  := "null"
	case Utility.IsString( oValue ) .and. ( ( string ) oValue ):StartsWith( "expression:" )
		cValue				:= " " + ( ( string ) oValue ):Substring( 11 ) + " "
    case Utility.IsString( oValue )
        cValue                  := string.Format( "'{0}'", SqlServerHelper.FixSQL( oValue ) )
    case Utility.IsFloat( oValue )
        oString                 := StringBuilder{ "{0:F" }
        oString:AppendFormat( "{0:D}", nDecimals )
        oString:Append( "}" )
        cValue                   := string.Format( CultureInfo.InvariantCulture, oString:ToString(), oValue )
    case Utility.IsInteger( oValue )
        cValue                  := string.Format( "{0:D}", oValue )
//    case MiscFuncs.IsVODate( oValue )
//        oDate                   := ( date ) oValue
//        cValue                  := string.Format( "'{0}'", oDate:ToString( "yyyy-MM-dd" ) )
    case Utility.IsDateTime( oValue )
        oDate                   := ( DateTime ) oValue
        // cValue                  := string.Format( "'{0}'", oDate:ToString( "yyyy-MM-dd" ) )
        cValue					:= "convert(datetime,'" + oDate:ToString( "yyyyMMdd" ) + "',112)"
    case Utility:IsLogic( oValue )
    	if ( logic ) oValue
    		cValue					:= "1"
    	else
    		cValue					:= "0"
    	endif
    case oValue is SqlStringExpression
    	oExpression				:= ( SqlStringExpression ) oValue
    	cValue					:= oExpression:Expression
    otherwise
        cValue                  := oValue:ToString()
    endcase

    return cValue

static method DateToString( oDateTime as DateTime ) as string
	local cReturn			as string

	cReturn				:= "convert(datetime,'" + oDateTime:ToString( "yyyyMMdd" ) + "',112)"  // oDateTime:ToString( "yyyy-MM-dd" )

	return cReturn

static method DateToString( oDateTime as Nullable<DateTime> ) as string
	local cReturn			as string

	if oDateTime == null
		cReturn				:= "null"
	else
		cReturn				:= "convert(datetime,'" + ( ( DateTime ) oDateTime ):ToString( "yyyyMMdd" ) + "',112)"  // oDateTime:ToString( "yyyy-MM-dd" )
	endif

	return cReturn

static method EscapeStringParameter( cParameter as string ) as string
	local cReturn			as string

	if cParameter:Contains( "'" )
		cReturn				:= cParameter:Replace( "'", "''" )
	else
		cReturn				:= cParameter
	endif

	return cReturn

static method FixSQL( oValue as object ) as string pascal
    local cValue            as string
    local oString           as StringBuilder

    oString                 := StringBuilder{ oValue:ToString() }
    oString:Replace( "'", "''" )
    cValue                  := oString:ToString()

    return cValue

static method BuildConnectionString( cServer as string, cDatabaseName as string, cUser as string, cPassword as string, cRole as string ) as string
	local cConnString			as string
	local oBuilder				as SqlConnectionStringBuilder

	oBuilder				:= SqlConnectionStringBuilder{}
	oBuilder:DataSource		:= cServer
	oBuilder:InitialCatalog	:= cDatabaseName
	oBuilder:UserID			:= cUser
	oBuilder:Password		:= cPassword
	cConnString				:= oBuilder:ConnectionString

    return cConnString

end class

end namespace

