// Application : XbaseInterface
// AppDBServer.prg , Created : 11.10.2019   05:45

begin namespace XbaseInterface

class AppDBServer inherit VO.DbServer

constructor( cFileName as string, lShareMode as logic, lReadOnlyMode as logic, cRDDName as string )

	super( cFileName, lShareMode, lReadOnlyMode, cRDDName )
	InitSettings.Check()

	return

virtual method CloseEx() as logic

	return super:Close()

//virtual method FieldGetByte( cFieldName ) as byte[]
//	local aValue		as byte[]
//	local oError 		as usual
//	local wPos 			as dword
//	local dwCurrentWorkArea as dword
//
//	lErrorFlag := false
//	try
//		VODBSelect( wWorkArea, @dwCurrentWorkArea )
//		if PCount() != 1
//			break DbError{ self, #FIELDGET, EG_ARG, "Incorrect number of arguments", uField, NULL_STRING }
//		endif
//
//		if (wPos := __GetFldPos( uField, wFieldCount )) = 0
//			break DbError{ self, #FIELDGET, EG_ARG, __CavoStr( __CAVOSTR_DBFCLASS_FIELDSPEC ), uField, "uField" }
//		endif
//
//		if ! VODBFieldGetBytes( wpos, @uRetVal )
//			break ErrorBuild( _VODBErrInfoPtr( ) )
//		endif
//
//		__DBSSetSelect( dwCurrentWorkArea )  //SE-060527
//
//	catch oEx as Exception
////		oErrorInfo := oError
//		__DBSSetSelect( dwCurrentWorkArea )  //SE-060527
////		self:Error( oErrorInfo, #FIELDGET )
//	end try
//
//	return aRetVal
//
//
virtual method FieldGetDecimal( cFieldName as string ) as decimal
	local nValue		as decimal
	local oValue		as object

	oValue			:= super:FieldGet( cFieldName )
//	if IsNumeric( oValue )
//		nValue			:= ( decimal ) oValue
//	else
		nValue			:= Convert.ToDecimal( oValue )
//	endif

	return nValue

virtual method FieldGetInt( cFieldName as string ) as int
	local nValue		as int
	local oValue		as object

	oValue			:= super:FieldGet( cFieldName )
//	if IsNumeric( oValue )
//		nValue			:= ( int ) oValue
//	else
		nValue			:= Convert.ToInt32( oValue )
//	endif

	return nValue

virtual method FieldGetString( cFieldName as string ) as string
	local cValue		as string
	local oValue		as object

	oValue			:= super:FieldGet( cFieldName )
	if IsString( oValue )
		cValue			:= ( string ) oValue
	else
		cValue			:= oValue:ToString()
	endif

	return cValue

virtual method FieldGetLogic( cFieldName as string ) as logic
	local lValue		as logic
	local oValue		as object

	oValue			:= super:FieldGet( cFieldName )
	if IsLogic( oValue )
		lValue			:= ( logic ) oValue
	else
		lValue			:= Convert.ToBoolean( oValue )
	endif

	return lValue

virtual method FGTrim( cFieldName as string ) as string
	local cValue		as string
	local oValue		as object

	oValue			:= super:FieldGet( cFieldName )
	if IsString( oValue )
		cValue			:= ( string ) oValue
	else
		cValue			:= super:FieldGetFormatted( cFieldName )
	endif

	return cValue:Trim()

virtual method FieldGetDate( cFieldName as string ) as XbDate
	local dValue		as date
	local dReturn		as XbDate

	dValue			:= ( date ) super:FieldGet( cFieldName )
	if dValue == null_date
		dReturn			:= XbDate{}
	else
		dReturn			:= XbDate{ int( Year( dValue ) ), int( Month( dValue ) ), int( Day( dValue ) ) }
	endif

	return dReturn

virtual method FieldGetDateTime( cFieldName as string ) as DateTime
	local dValue		as DateTime

	dValue			:= ( date ) super:FieldGet( cFieldName )

	return dValue

virtual method FieldGetNullableDateTime( cFieldName as string ) as Nullable<DateTime>
	local dValue		as Nullable<DateTime>
	local dDate			as date

	dDate			:= ( date ) super:FieldGet( cFieldName )
	if dDate == null_date
		dValue			:= null
	else
		dValue			:= dDate
	endif

	return dValue

virtual method FieldGetDateString( cFieldName as string ) as string
	local dValue		as date
	local cValue		as string

	dValue			:= ( date ) super:FieldGet( cFieldName )
	if dValue == null_date
		cValue			:= ""
	else
		cValue			:= DToS( dValue )
	endif

	return cValue

virtual method FieldPutDecimal( cFieldName as string, nValue as decimal ) as void

	super:FieldPut( cFieldName, float( real8( nValue ) ) )

	return

virtual method FieldPutInt( cFieldName as string, nValue as int ) as void

	super:FieldPut( cFieldName, nValue )

	return

virtual method FieldPutString( cFieldName as string, cValue as string ) as void

	super:FieldPut( cFieldName, cValue )

	return

virtual method FieldPutLogic( cFieldName as string, lValue as logic ) as void

	super:FieldPut( cFieldName, lValue )

	return

virtual method FieldPutDateTime( cFieldName as string, dValue as DateTime ) as void

	super:FieldPut( cFieldName, ( date ) dValue )

	return

virtual method SeekEx( cSearchExpr as string ) as logic
	local lReturn			as logic

	lReturn			:= self:Seek( cSearchExpr )

	return lReturn

virtual method SeekEx( cSearchExpr as string, lSoftSeek as logic ) as logic
	local lReturn			as logic

	lReturn			:= self:Seek( cSearchExpr, lSoftSeek )

	return lReturn

virtual method SeekEx( cSearchExpr as string, lSoftSeek as logic, lLast as logic ) as logic
	local lReturn			as logic

	lReturn			:= self:Seek( cSearchExpr, lSoftSeek, lLast )

	return lReturn

virtual method SetOrderEx( cOrderName as string ) as logic
	local lReturn			as logic

	lReturn			:= self:SetOrder( cOrderName )

	return lReturn


end class

end namespace

